﻿using Hims.Api.Utilities;
using Hims.Domain.Services;
using Hims.Shared.DataFilters;
using Hims.Shared.EntityModels;
using Microsoft.AspNetCore.Authorization;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;

namespace Hims.Api.Controllers
{
    /// <summary>
    /// The PaymentMapHelperController.
    /// </summary>
    /// <seealso cref="Hims.Api.Utilities.BaseController" />
    [Authorize]
    [Route("api/payment-maphelper")]
    [ApiController]
    public class PaymentMapHelperController : BaseController
    {
        /// <summary>
        /// The payment map helper service
        /// </summary>
        private readonly IPaymentMapHelperService paymentMapHelperService;

        /// <inheritdoc />
        public PaymentMapHelperController(IPaymentMapHelperService paymentMapHelperService)
        {
            this.paymentMapHelperService = paymentMapHelperService;
        }

        /// <summary>
        /// Fetches the added lab bill asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        [HttpPost]
        [Route("fetch-added-bill-id")]
        public async Task<ActionResult> FetchAddedLabBillAsync([FromBody] PaymentMapHelperModel model)
        {
            model = (PaymentMapHelperModel)EmptyFilter.Handler(model);
            var responses = await this.paymentMapHelperService.FindAsync(model.PaymentInitiationLogId);
            return this.Success(responses);
        }

        /// <summary>
        /// Adds the lab bill identifier asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        [HttpPost]
        [Route("add")]
        public async Task<ActionResult> AddLabBillIdAsync([FromBody] PaymentMapHelperModel model)
        {
            model = (PaymentMapHelperModel)EmptyFilter.Handler(model);
            var responses = await this.paymentMapHelperService.AddAsync(model);
            
            return this.Success(responses);
        }

    }
}
